﻿#pragma once

// Exclude rarely-used stuff from Windows headers
#if !defined(WIN32_LEAN_AND_MEAN)
#define WIN32_LEAN_AND_MEAN
#endif

// Use STL min/max functions
#if !defined(NOMINMAX)
#define NOMINMAX
#endif

// Use math constant defines (e.g. M_SQRT2)
#if !defined(_USE_MATH_DEFINES)
#define _USE_MATH_DEFINES		
#endif

#include <d3d11_1.h>
#include <DirectXMath.h>
#include <DirectXPackedVector.h>
#include <DirectXCollision.h>
#include <DirectXColors.h>

#include <d2d1.h>
#include <dwrite.h>

#include <algorithm>
#include <array>
#include <assert.h>
#include <exception>
#include <malloc.h>
#include <map>
#include <memory>
#include <sstream>
#include <string>
#include <vector>

// Used for ComPtr
#include <wrl/client.h>
using Microsoft::WRL::ComPtr;

#pragma warning(push)
#pragma warning(disable : 4005)
#include <stdint.h>
#pragma warning(pop)

#if (_WIN32_WINNT >= 0x0602 /*_WIN32_WINNT_WIN8*/) && !defined(DXGI_1_2_FORMATS)
#define DXGI_1_2_FORMATS
#endif

using std::unique_ptr;
using std::shared_ptr;
using std::weak_ptr;

using std::vector;
using std::string;
using std::wstring;

using DirectX::XMVECTOR;
using DirectX::XMMATRIX;

using DirectX::XMFLOAT3A;
using DirectX::XMFLOAT4A;
using DirectX::XMFLOAT4X4A;

// Use the FXMVECTOR alias to pass up to the first three instances of XMVECTOR used as arguments to a function.
// Use the GXMVECTOR alias to pass the 4th instance of an XMVECTOR used as an argument to a function.
// Use the CXMVECTOR alias to pass any further instances of XMVECTOR used as arguments.
// Note: For output parameters(not return parameters), always use XMVECTOR* or XMVECTOR& and ignore them with respect to the preceding rules for input parameters.
using DirectX::FXMVECTOR;
using DirectX::GXMVECTOR;
using DirectX::CXMVECTOR;
using DirectX::CXMMATRIX;